require_relative '../rspec_helper'
require 'vaToolSet/vaToolSet_pageObject'

describe '[Story VARUT-374 Unauthenticated Landing Page]'do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-645| TC#VARUT-654: Validate unauthenticated landing page' do

    it 'Verify header and footer and elements on landing page' do
      @vts_po.landing.title_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.has_expected_title?).to eq(true)
      @vts_po.landing.utilityName_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.utilityName_element.text).to eq("VA Tool Set")
      @vts_po.landing.description_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.description_element.text).to eq("The VA Tool Set app provides access to VA Mobile app configuration and management tools for use by VA Staff users with appropriate authorization credentials.")
      @vts_po.landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.login_element.text).to eq("Login")
      @vts_po.landing.leftFooter_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.leftFooter_element.text).to eq("VA Tool Set - v2.3.0")
      @vts_po.landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      expect(@vts_po.landing.rightFooter_element.text).to eq("Not logged in")
    end

  end
end